<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if (iaView::REQUEST_HTML == $iaView->getRequestType()) {
    $iaProperty = $iaCore->factoryItem('estate');
    $iaLocation = $iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common');

    $listing = $iaProperty->getById(end($iaCore->requestPath), true, true);

    if (empty($listing)) {
        // delete recently viewed listing
        unset($_SESSION[iaEstate::SESSION_RECENT_KEY][end($iaCore->requestPath)]);

        return iaView::errorPage(iaView::ERROR_NOT_FOUND);
    }

    // formatting breadcrumb
    foreach ($iaLocation->getParents($listing['location_id']) as $location) {
        iaBreadcrumb::add($location['title'], IA_MODULE_URL . $location['url']);
    }
    iaBreadcrumb::replaceEnd(iaLanguage::get('listing_details') . ': ' . $listing[iaEstate::COLUMN_ID], IA_SELF);

    switch ($listing['status']) {
        case iaEstate::STATUS_HIDDEN:
        case iaCore::STATUS_APPROVAL:
            if (iaUsers::hasIdentity() && iaUsers::getIdentity()->id == $listing['member_id']) {
                $message = (iaEstate::STATUS_HIDDEN == $listing['status']) ? 'listing_is_hidden' : 'listing_is_approval';
                $iaView->setMessages(iaLanguage::get($message), iaView::ALERT);
            } elseif (isset($_COOKIE[iaEstate::COOKIE_GUEST_ACCESS_KEY])) // current visitor posted this listing as a guest
            {
                if (!in_array($iaProperty->createUserAccessHash($listing),
                    explode(',', $_COOKIE[iaEstate::COOKIE_GUEST_ACCESS_KEY]))
                ) {
                    return iaView::accessDenied();
                }
            } else {
                return iaView::accessDenied();
            }

            break;

        default:
            $iaProperty->incrementViewsCounter($listing[iaEstate::COLUMN_ID]);

            if (!isset($_SESSION[iaEstate::SESSION_RECENT_KEY])) {
                $_SESSION[iaEstate::SESSION_RECENT_KEY] = [];
            }
            $array = $_SESSION[iaEstate::SESSION_RECENT_KEY];
            if (!array_key_exists($listing[iaEstate::COLUMN_ID], $array)) {
                $array[$listing[iaEstate::COLUMN_ID]] = $listing;
            }
            if (count($array) > $iaCore->get('realestate_recently_viewed_num', 10)) {
                $array = array_splice($array, 0, 1);
            }
            $_SESSION[iaEstate::SESSION_RECENT_KEY] = $array;
    }

    $iaCore->startHook('phpViewListingBeforeStart', [
        'listing' => $listing[iaEstate::COLUMN_ID],
        'item' => $iaProperty->getItemName(),
        'title' => $listing['address'],
        'desc' => $listing['description']
    ]);

    $iaField = $iaCore->factory('field');
    $iaItem = $iaCore->factory('item');

    if (iaUsers::hasIdentity() && iaUsers::getIdentity()->id == $listing['member_id']) {
        $actionUrls = [
            iaCore::ACTION_EDIT => $iaProperty->url(iaCore::ACTION_EDIT, $listing),
            iaCore::ACTION_DELETE => $iaProperty->url(iaCore::ACTION_DELETE, $listing)
        ];

        $iaView->assign('tools', $actionUrls);

        $iaItem->setItemTools([
            'id' => 'action-edit',
            'title' => iaLanguage::get('edit_listing'),
            'attributes' => [
                'href' => $actionUrls[iaCore::ACTION_EDIT]
            ]
        ]);
        $iaItem->setItemTools([
            'id' => 'action-delete',
            'title' => iaLanguage::get('delete_listing'),
            'attributes' => [
                'href' => $actionUrls[iaCore::ACTION_DELETE],
                'class' => 'js-delete-listing'
            ]
        ]);
    }

    // populating the Author block
    $memberData = $iaCore->factory('users')->getInfo($listing['member_id']);
    if (!empty($memberData['registered_status'])) {
        $ownerData['count'] = $iaDb->one(iaDb::STMT_COUNT_ROWS, iaDb::convertIds($memberData['id'], 'member_id'),
            iaEstate::getTable());
        $ownerData['listings'] = $iaProperty->get('e.`member_id` = ' . $listing['member_id'] . ' AND e.`id` != ' . $listing[iaEstate::COLUMN_ID],
            0, 5, iaDb::FUNCTION_RAND);

        // TODO: custom http validation
        if (isset($memberData['website']) && $memberData['website'] && preg_match('#^http#i',
                $memberData['website']) !== 1
        ) {
            $memberData['website'] = 'http://' . $memberData['website'];
        }

        $iaView->assign('author', $memberData);
    }
    //

    // populating the neighbors paginator
    $neighborhood = [
        'current' => $iaDb->one_bind(iaDb::STMT_COUNT_ROWS,
            '`status` = :status AND `location_id` = :location AND `id` <= :id ORDER BY `id`',
            [
                'status' => iaEstate::STATUS_AVAILABLE,
                'location' => $listing[iaEstate::COLUMN_LOCATION],
                'id' => $listing[iaEstate::COLUMN_ID]
            ],
            iaEstate::getTable()),
        'total' => $iaDb->one_bind(iaDb::STMT_COUNT_ROWS,
            '`status` = :status AND `location_id` = :location ORDER BY `id`',
            ['status' => iaEstate::STATUS_AVAILABLE, 'location' => $listing[iaEstate::COLUMN_LOCATION]],
            iaEstate::getTable()),
        'url' => ['previous' => null, 'next' => null]
    ];

    $stmt = iaDb::printf('e.`location_id` = :location_id AND e.`id` :action :id', $listing);
    if ($entry = $iaProperty->get(iaDb::printf($stmt, ['action' => '<']), 0, 1,
        ['field' => iaEstate::COLUMN_ID, 'direction' => iaDb::ORDER_DESC])
    ) {
        $neighborhood['url']['previous'] = $iaProperty->url('view', $entry[0]);
    }
    if ($entry = $iaProperty->get(iaDb::printf($stmt, ['action' => '>']), 0, 1)) {
        $neighborhood['url']['next'] = $iaProperty->url('view', $entry[0]);
    }

    $iaView->assign('neighborhood', $neighborhood);
    //

    $address = sprintf('%s %s %s', $listing['address'], $listing['address2'], $listing['country']);

    $sections = $iaField->getTabs($iaProperty->getItemName(), $listing);

    $iaView->assign('address', $address);
    $iaView->assign('item', $listing);
    $iaView->assign('sections', $sections);

    $iaView->title($address);
    $iaView->caption($listing['address']);

    $iaView->set('description', $listing['meta_description']);
    $iaView->set('keywords', $listing['meta_keywords']);

    unset($listing['built_year'], $listing['price'], $listing['address'], $listing['size']);

    $iaView->display('view');
}
