<div class="ia-item ia-item--border ia-item--{$listing.status} {if $listing.featured}ia-item--featured{/if} {if $listing.sponsored}ia-item--sponsored{/if} has-panel">
    {if !empty($listing.gallery)}
        <a class="ia-item__image" href="{ia_url type='url' item='estates' data=$listing}">
            {ia_image file=$listing.gallery[0] type='thumbnail' title=$listing.address class='img-responsive'}
            <span class="ia-item__image__badge">
                <span class="fa fa-image"></span> {$listing.gallery_num}
            </span>
        </a>
    {/if}

    <div class="ia-item__labels">
        {if iaEstate::STATUS_SOLD == $listing.status}
            <span class="label label-danger">{lang key='sold'}</span>
        {elseif $member && $member.id == $listing.member_id
        && (iaCore::STATUS_APPROVAL == $listing.status || iaEstate::STATUS_HIDDEN == $listing.status)}
            <span class="label label-{$listing.status}" title="{lang key=$listing.status default=$listing.status}"><span class="fa fa-info-sign"></span> {lang key=$listing.status default=$listing.status}</span>
        {else}
            <span class="label label-{$listing.status}" title="{lang key=$listing.status default=$listing.status}"><span class="fa fa-info-sign"></span> {lang key=$listing.status default=$listing.status}</span>
        {/if}
        {if $listing.sponsored}<span class="label label-warning" title="{lang key='sponsored'}"><span class="fa fa-star"></span> {lang key='sponsored'}</span>{/if}
        {if $listing.featured}<span class="label label-info" title="{lang key='featured'}"><span class="fa fa-star-o"></span> {lang key='featured'}</span>{/if}
    </div>

    <div class="ia-item__content">
        <div class="ia-item__actions">
            {printFavorites item=$listing itemtype='estate' guests=true}
            {accountActions item=$listing itemtype='estate'}
            <a href="{ia_url item='estates' data=$listing type='url'}">{lang key='details'} <span class="fa fa-angle-double-right"></span></a>
        </div>

        <div class="ia-item__title">
            <a href="{$listing.link}">{$listing.address|escape}</a>
        </div>

        {ia_hooker name='smartyItemListAfterTitle'}

        <p>
            {$listing.location}{if !empty($listing.state)}, {$listing.state}{/if}
            {$listing.zipcode|escape}
        </p>

        <div class="ia-item__additional">
            {if $listing.price}<p><span class="fa fa-tag"></span> {$listing.price_formatted}</p>{/if}
            <p><span class="fa fa-home"></span> <a href="{$smarty.const.IA_URL}search/properties/type:{$listing.type}/">{lang key="field_estate_type+{$listing.type}"}</a></p>
            {if !empty($listing.bedrooms)}<p title="{lang key='field_estate_bedrooms'}"><span class="fa fa-bed"></span> {lang key="field_estate_bedrooms+{$listing.bedrooms}"}</p>{/if}
            {if !empty($listing.bathrooms)}<p title="{lang key='field_estate_bathrooms'}"><span class="fa fa-tint"></span> {lang key="field_estate_bathrooms+{$listing.bathrooms}"}</p>{/if}
        </div>

        <div class="ia-item__additional"></div>

        {ia_hooker name='smartyItemListBeforeInfoPost'}
    </div>

    <div class="ia-item__panel">
        {if 'favorites' != $core.page.name}
            <span class="ia-item__panel__item pull-right">
                <a class="btn-compare {(isset($smarty.session[iaEstate::SESSION_COMPARISON_KEY][$listing.id])) ? 'btn-compare--added' : ''}" data-id="{$listing.id}" href="#" data-disabled="{(isset($smarty.session[iaEstate::SESSION_COMPARISON_KEY][$listing.id])) ? 'disabled' : ''}"><span class="fa fa-sort-amount-desc"></span>
                    <span class="btn-compare__text">{(isset($smarty.session[iaEstate::SESSION_COMPARISON_KEY][$listing.id])) ? {lang key='remove_from_compare'} : {lang key='mark_to_compare'}}</span>
                </a>
            </span>
        {/if}

        <span class="ia-item__panel__item">
            {lang key='id'}: {$listing.id}
        </span>
        <span class="ia-item__panel__item" title="{lang key='added_date'}">
            <span class="fa fa-clock-o"></span> {$listing.date_added|date_format}
        </span>
        <span class="ia-item__panel__item">
            <span class="fa fa-eye"></span> {$listing.views_num}
        </span>
    </div>
</div>