{if isset($realestate.recent)}
    <div class="ia-items recent-real-estates">
        {foreach $realestate.recent as $entry}
            <div class="ia-item">
                {if !empty($entry.gallery)}
                    <a class="ia-item__image" href="{$entry.link}">{ia_image file=$entry.gallery[0] type='thumbnail' title=$entry.address width=130}</a>
                {/if}

                <div class="ia-item__content">
                    <h4 class="ia-item__title">
                        <a href="{$entry.link}">{$entry.address|escape}</a>
                    </h4>
                    {if !empty($entry.price)}
                        <p class="text-success"><b><span class="fa fa-tag"></span> {$entry.price_formatted}</b></p>
                    {/if}
                    <div class="ia-item__additional">
                        <p><span class="fa fa-map-marker"></span> {$entry.address2|escape}</p>
                        <p>{lang key='id'}: {$entry.id}</p>
                    </div>
                    <p>{$entry.description|strip_tags|truncate:'100':'...'}</p>
                </div>
            </div>
        {/foreach}
    </div>
{/if}