{if !empty($author)}
    <div class="enquire">
        <div class="enquire__header">{$block.title|escape}</div>
        <div class="enquire__content">
            <form action="{$smarty.const.IA_URL}actions.json" method="post" id="js-enq-property-form">
                {preventCsrf}
                <p class="enquire__info">{lang key='enquire_form_text'}</p>
                <div class="form-group">
                    <input type="text" id="from-name" name="from_name" class="form-control" placeholder="{lang key='your_name'}">
                </div>
                <div class="form-group">
                    <input type="text" id="from-email" name="from_email" class="form-control" placeholder="{lang key='your_email'}">
                </div>
                <div class="form-group">
                    <input type="text" id="from-phone" name="from_phone" class="form-control" placeholder="{lang key='your_phone'}">
                </div>
                <div class="form-group">
                    <textarea id="email-body" name="email_body" class="form-control" rows="4" placeholder="{lang key='your_comments'}"></textarea>
                </div>

                {if !$member}
                    <div class="form-group m-t">
                        <div class="captcha">{captcha}</div>
                    </div>
                {/if}

                <button class="btn btn-primary btn-block" type="submit">{lang key='send_enquiry'}</button>

                <input type="hidden" name="action" value="send_email">
                <input type="hidden" name="author_id" value="{$author.id}">
                <input type="hidden" name="regarding" value="{$core.page.title|escape}">
            </form>
        </div>
    </div>

{ia_add_js}
$(function() {
    $('#js-enq-property-form').on('submit', function(e) {
        e.preventDefault();

        var $form = $(this), data = { };

        $form.serializeArray().map(function(x){ data[x.name] = x.value; })
        if ('' != data.email_body && '' != data.from_phone) data.email_body+= '\n\nPhone: ' + data.from_phone;

        $.post($form.attr('action'), data, function(response) {
            if (!response.error) $('[type="submit"], input, textarea', $form).prop('disabled', true);
            intelli.notifFloatBox({ msg: response.message, type: response.error ? 'error' : 'success', autohide: true });
        });
    });
});
{/ia_add_js}

    {if $enquiry_form_enabled}
        <div class="r-callback">
            <a class="r-callback__toggle js-request-toggle" href=""><span class="fa fa-phone"></span> {lang key='request_callback'}</a>
            <form action="{$core.config.baseurl}realestate/callback-request.json" class="r-callback__content" method="post" style="display: none;" id="js-enq-callback-form">
                {preventCsrf}
                <div class="form-group">
                    <label for="request_time">{lang key='best_time'}</label>
                    <select class="form-control" name="best_time" id="request_time">
                        <option>Morning</option>
                        <option>Evening</option>
                    </select>
                </div>
                <div class="form-group">
                    <input type="text" name="phone" class="form-control" maxlength="20" placeholder="{lang key='your_phone'}">
                </div>
                <div class="form-group">
                    <textarea name="comment" class="form-control" rows="4" placeholder="{lang key='your_comments'}"></textarea>
                </div>

                {if !$member}
                    <div class="form-group m-t">
                        <div class="captcha">
                            {captcha}
                        </div>
                    </div>
                {/if}

                <button class="btn btn-primary btn-block" type="submit">{lang key='send_request'}</button>

                <input type="hidden" name="action" value="callback-request">
                <input type="hidden" name="author" value="{$author.id}">
                <input type="hidden" name="title" value="{$core.page.title|escape}">
            </form>
        </div>
        {ia_add_js}
$(function() {
    $('.js-request-toggle').on('click', function(e) {
        e.preventDefault();

        var $this = $(this),
            $content = $this.next();

        if (!$content.hasClass('is-visible')) {
            $content.slideDown('fast', function() {
                $content.addClass('is-visible');
            });
        } else {
            $content.slideUp('fast', function() {
                $content.removeClass('is-visible');
            });
        }
    });

    $('#js-enq-callback-form').on('submit', function(e) {
        e.preventDefault();

        var $form = $(this);

        $.post($form.attr('action'), $form.serialize(), function(response) {
            if (!response.error) $('button, input, textarea, select', $form).prop('disabled', true);
            intelli.notifFloatBox({ msg: response.message, type: response.error ? 'error' : 'success', autohide: true });
        });
    });
});
        {/ia_add_js}
    {/if}
{/if}