<form method="post" enctype="multipart/form-data" class="sap-form form-horizontal">
    {preventCsrf}

    {capture name='title' append='field_before'}
        <div class="row">
            <label class="col col-lg-2 control-label">
                {lang key='location'} {lang key='field_required'}
            </label>
            <div class="col col-lg-4">
                <input type="text" id="js-location-label" class="gap" value="{lang key='_not_selected_'}" disabled>
                <input type="hidden" id="input-location" name="parent" value="{$item.parent}">
                <div class="js-selectboxes-group">
                    <select class="js-iad gap" data-children="{$item.parents}" data-id="{$id}">
                        <option value="">{lang key='_select_'}</option>
                        {foreach $categories as $category}
                            <option value="{$category.id}">{$category.title|escape}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>
    {/capture}

    {capture name='title' append='field_after'}
        <div class="row">
            <label class="col col-lg-2 control-label">{lang key='title_alias'} {lang key='field_required'}</label>
            <div class="col col-lg-4">
                <input type="text" name="alias" id="input-alias" value="{$item.alias}">
                <p class="help-block text-break-word">{lang key='url_will_be_set_to'} <span class="text-danger" id="js-url-preview">{$smarty.const.IA_MODULE_URL}{$item.url}</span></p>
            </div>
        </div>
    {/capture}

    {include 'field-type-content-fieldset.tpl' isSystem=true}
</form>
{ia_add_media files='js:jquery/plugins/jquery.ia-dropdown.min, js:_IA_URL_modules/realestate/js/admin/manage-locations'}