$('a', '#re-gmap-info').remove();
$('#re-gmap').fadeIn();

function runGeocoder() {
    var fullAddress = $('#field_address').val() + ', ' + $('#field_city').val() + ' ' + ($('#state_id').val() ? $('option[value="' + $('#state_id').val() + '"]', '.state_sb').text() + ', ' : '') + $('#field_zip').val();
    $('#re-gmap-info').text('Searching for coordinates of ' + fullAddress + '...');
    geoCoder.geocode({'address': fullAddress}, function (result, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            bounds.extend(result[0].geometry.location);
            map.setCenter(result[0].geometry.location);
            var hintText = 'Location found';
            hintText += '. ';
            hintText += intelli.marker ? 'Move the location marker if needed' : 'Click to specify the real estate position';
            hintText += '.';
            $('#re-gmap-info').text(hintText);
        }
        else {
            $('#re-gmap-info').text('Unable to find location specified (' + fullAddress + ')');
        }
    });
}

intelli.marker = false;
var map = new google.maps.Map(document.getElementById('re-gmap'), {mapTypeId: google.maps.MapTypeId.HYBRID, zoom: 11});
var bounds = new google.maps.LatLngBounds();
var geoCoder = new google.maps.Geocoder();

google.maps.event.addListener(map, 'click', function (e) {
    if (intelli.marker) {
        intelli.marker.setPosition(e.latLng);
    }
    else {
        intelli.marker = new google.maps.Marker(
            {
                animation: google.maps.Animation.BOUNCE,
                icon: intelli.config.packages.realestate.tpl_url + 'front/img/house-icon.png',
                position: e.latLng,
                map: map,
                title: _t('your_real_estate_is_here')
            });
    }
    map.panTo(e.latLng);
});

runGeocoder();

$('#field_address, #field_city, #field_zipcode').blur(runGeocoder);
$('.state_sb').change(runGeocoder);
