$(function(){
    $('.js-location-example').on('click', function(e){
        e.preventDefault();
        $('#qs-keyword').val($(this).text());
    });

    $('#qs-keyword').typeahead({
        source: function(query, process){
            return $.ajax({
                url: intelli.config.url + 'realestate/address.json',
                dataType: 'json',
                data: {q: query},
                success: function(response){
                    return process(response);
                }
            });
        }
    });

    var $location = $('#js-re-l'),
        $subLocation = $('#js-re-sl');

    $location.on('change', function () {
        var value = $(this).val();

        $subLocation.val(0).prop('disabled', true).find('option:not(:first)').remove();

        if (value !== '') {
            $.getJSON(intelli.config.packages.realestate.url + 'locations/read.json', {id: value}, function (response) {
                if (response && response.length > 0) {
                    var d = $subLocation.data('value');

                    $.each(response, function (index, item) {
                        var $option = $('<option>').val(item.id).text(item.text);
                        if (d == item.id) $option.attr('selected', true);
                        $subLocation.append($option);
                    });

                    $subLocation.prop('disabled', false);
                }
            });
        }
        else {
            $subLocation.prop('disabled', true);
        }
    });

    if ($subLocation.data('value')) {
        $location.trigger('change');
    }
});