Ext.onReady(function() {
    var grid = new IntelliGrid({
        columns: [
            'selection',
            {name: 'gallery', title: _t('field_estate_pictures'), icon: 'image', click: function(record, field){
                $.fancybox.open(record.get(field));
            }},
            {name: 'address', title: _t('address'), width: 2, editor: 'text'},
            {name: 'type', title: _t('type'), width: 130},
            {name: 'id', title: _t('id'), width: 90},
            {name: 'date_added', title: _t('date'), width: 170, editor: 'date'},
            'status',
            'update',
            'delete',
            {name: 'copy', title: _t('copy'), icon: 'plus', click: function(record, field){
                window.location.href = window.location.href + 'add/?' + record.get('id')
            }}
        ],
        sorters: [{property: 'date_added', direction: 'DESC'}],
        statuses: ['available', 'hidden', 'approval', 'sold', 'rented'],
        texts: {
            delete_multiple: _t('do_you_want_to_delete_selected_listings'),
            delete_single: _t('do_you_want_to_delete_this_listing')
        }
    }, false);

    grid.toolbar = new Ext.Toolbar({
        items: [
            {
                emptyText: _t('address'),
                id: 'fltAddress',
                name: 'address',
                listeners: intelli.gridHelper.listener.specialKey,
                width: 150,
                xtype: 'textfield'
            }, {
                displayField: 'title',
                editable: false,
                emptyText: _t('type'),
                name: 'type',
                store: intelli.gridHelper.store.ajax(grid.url + 'types.json'),
                typeAhead: true,
                valueField: 'value',
                width: 130,
                xtype: 'combo'
            }, {
                emptyText: _t('id'),
                name: 'id',
                maxLength: 8,
                width: 85,
                xtype: 'textfield',
                listeners: intelli.gridHelper.listener.specialKey
            }, {
                editable: false,
                emptyText: _t('category'),
                name: 'category',
                store: ['sale', 'rent'],
                typeAhead: true,
                width: 90,
                xtype: 'combo'
            }, {
                displayField: 'title',
                editable: false,
                emptyText: _t('status'),
                id: 'fltStatus',
                name: 'status',
                store: grid.stores.statuses,
                typeAhead: true,
                valueField: 'value',
                xtype: 'combo'
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid);
                },
                id: 'fltBtn',
                text: '<i class="i-search"></i> ' + _t('search')
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid, true);
                },
                text: '<i class="i-close"></i> ' + _t('reset')
            }]
    });

    grid.init();

    var filterStatus = intelli.urlVal('status');

    if (filterStatus) {
        Ext.getCmp('fltStatus').setValue(filterStatus);
        intelli.gridHelper.search(grid);
    }
});
