Ext.onReady(function () {
    var grid = new IntelliGrid(
        {
            columns: [
                'selection',
                {name: 'title', title: _t('title'), width: 1},
                {name: 'url', title: _t('path'), width: 1},
                {name: 'count', title: _t('number_of_listings'), width: 95},
                {name: 'order', title: _t('order'), width: 50, editor: 'text'},
                'status',
                'update',
                'delete'
            ],
            texts: {
                delete_multiple: _t('are_you_sure_to_delete_selected_categories'),
                delete_single: _t('are_you_sure_to_delete_this_category')
            }
        }, false);

    grid.toolbar = new Ext.Toolbar({
        items: [
            {
                emptyText: _t('title'),
                listeners: intelli.gridHelper.listener.specialKey,
                name: 'title',
                width: 250,
                xtype: 'textfield'
            }, {
                displayField: 'title',
                editable: false,
                emptyText: _t('status'),
                name: 'status',
                store: grid.stores.statuses,
                typeAhead: true,
                valueField: 'value',
                width: 100,
                xtype: 'combo'
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid)
                },
                id: 'fltBtn',
                text: '<i class="i-search"></i> ' + _t('search')
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid, true)
                },
                text: '<i class="i-close"></i> ' + _t('reset')
            }]
    });

    grid.init();
});