<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if (iaView::REQUEST_HTML == $iaView->getRequestType()) {
    $iaProperty = $iaCore->factoryItem('estate');
    $iaLocation = $iaCore->factoryModule('location', $iaProperty->getModuleName(), 'common');

    $blocksData = [];

    if ($iaView->blockExists('real_estate_featured')) {
        if ($data = $iaProperty->get(['featured' => 1], 0, $iaCore->get('realestate_featured_num', 7), ' RAND()')) {
            $blocksData['featured'] = $data;
        }
    }

    if ($iaView->blockExists('real_estate_sponsored')) {
        if ($data = $iaProperty->get(['sponsored' => 1], 0, $iaCore->get('realestate_sponsored_num', 8), ' RAND()')) {
            $blocksData['sponsored'] = $data;
        }
    }

    if ($iaView->blockExists('top_agents')) {
        $iaAgent = $iaCore->factoryModule('agent', $iaProperty->getModuleName(), 'common');

        if ($data = $iaAgent->getTopAgents(4)) {
            $blocksData['agents'] = $data;
        }
    }

    if ($iaView->blockExists('real_estate_footer_locations')) {
        $data = $iaLocation->search(
            [
                ['column' => iaLocation::COLUMN_STATUS, 'cond' => '=', 'value' => iaCore::STATUS_ACTIVE],
                ['column' => iaLocation::NS_LEVEL, 'cond' => '>', 'value' => 1]
            ],
            null, ['field' => 'num_listings', 'direction' => iaDb::ORDER_DESC],
            0, $iaCore->get('realestate_footer_locations_num', 20)
        );

        if ($data) {
            $blocksData['locations'] = $data;
        }
    }

    if ($iaView->blockExists('real_estate_footer_states')) {
        $data = $iaLocation->search(
            [
                ['column' => iaLocation::COLUMN_STATUS, 'cond' => '=', 'value' => iaCore::STATUS_ACTIVE],
                ['column' => iaLocation::NS_LEVEL, 'cond' => '=', 'value' => 1]
            ],
            null, ['field' => 'num_listings', 'direction' => iaDb::ORDER_DESC], 0,
            $iaCore->get('realestate_footer_states_num', 12)
        );
        if ($data) {
            $blocksData['states'] = $data;
        }
    }

    if ($iaView->blockExists('real_estate_quick_search')) {
        $iaField = $iaCore->factory('field');

        $blocksData['search'] = [];

        $fields = ['type', 'bathrooms', 'bedrooms', 'category'];
        $stmt = iaDb::printf("`item` = ':item' AND `name` IN (':fields')",
            ['item' => $iaProperty->getItemName(), 'fields' => implode("','", $fields)]);

        $fields = $iaDb->keyvalue(['name', 'values'], $stmt, $iaField::getTable());
        foreach ($fields as $name => $values) {
            $titles = [];
            foreach (explode(',', $values) as $key) {
                $titles[$key] = iaLanguage::get('field_' . $iaProperty->getItemName() . '_' . $name . '+' . $key, $key);
            }

            $blocksData['search'][$name] = $titles;
        }

        $numEstates = $iaDb->one('COUNT(*)', "`status` IN ('available', 'rented')", iaEstate::getTable());

        $blocksData['search']['defaults'] = [
            'category' => isset($_GET['category']) ? iaSanitize::paranoid($_GET['category']) : null,
            'keyword' => isset($_GET['keyword']) ? iaSanitize::html(iaSanitize::tags($_GET['keyword'])) : null,
            'type' => isset($_GET['type']) ? iaSanitize::paranoid($_GET['type']) : null,
            'price' => [
                'min' => isset($_GET['price']['f']) && $_GET['price']['f'] ? (int)$_GET['price']['f'] : null,
                'max' => isset($_GET['price']['t']) && $_GET['price']['t'] ? (int)$_GET['price']['t'] : null,
            ],
            'bath' => isset($_GET['bathrooms']) ? iaSanitize::paranoid($_GET['bathrooms']) : null,
            'bed' => isset($_GET['bedrooms']) ? iaSanitize::paranoid($_GET['bedrooms']) : null,
            'i' => isset($_GET['i']),
            'children_loc' => $iaView->get('children_loc')
        ];

        $iaView->assign('num_estates', $numEstates);
    }

    if ($iaView->blockExists('recent_real_estates')) {
        if ($data = $iaProperty->get(null, 0, $iaCore->get('realestate_recent_num', 10),
            ['field' => 'date_modified', 'direction' => 'DESC'])
        ) {
            $blocksData['recent'] = $data;
        }
    }

    if ($iaView->blockExists('real_estate_popular_locations')) {
        $data = $iaLocation->search(
            [
                ['column' => iaLocation::COLUMN_STATUS, 'cond' => iaLocation::SQL_CONDITION_EQUAL, 'value' => iaCore::STATUS_ACTIVE],
                ['column' => iaLocation::NS_LEVEL, 'cond' => '>', 'value' => 1]
            ],
            [iaLocation::COLUMN_TITLE, iaLocation::COLUMN_URL, iaLocation::FAKE_COLUMN_ABBREVIATION, 'num_listings'],
            'd.`num_listings` DESC, RAND()', 0, $iaCore->get('realestate_popular_num', 14)
        );

        if ($data) {
            $blocksData['popularCities'] = $data;

            $data = $data[mt_rand(0, count($data) - 1)];
            if (isset($data[iaLocation::COLUMN_TITLE])) {
                $blocksData['search']['example'] = $data[iaLocation::COLUMN_TITLE] . (empty($data[iaLocation::FAKE_COLUMN_ABBREVIATION]) ? '' : ', ' . $data[iaLocation::FAKE_COLUMN_ABBREVIATION]);
            }
        }
    }

    if ($iaView->blockExists('real_estate_types')) {
        $iaField = $iaCore->factory('field');
        $blocksData['types'] = $iaField->getValues('type', $iaProperty->getItemName());
    }

    if ($iaView->blockExists('real_estate_tools')) {
        $data = empty($_SESSION[iaEstate::SESSION_RECENT_KEY]) ? [] : $_SESSION[iaEstate::SESSION_RECENT_KEY];

        // we have to remove currently viewed listing if it's a listing details page
        if ('realestate_view' == $iaView->name() && ($item = $iaView->getValues('item'))) {
            unset($data[$item['id']]);
        }

        $blocksData['viewed'] = $data;
        $blocksData['saved'] = isset($_SESSION[iaUsers::SESSION_FAVORITES_KEY][$iaProperty->getItemName()]['items'])
            ? (array)$_SESSION[iaUsers::SESSION_FAVORITES_KEY][$iaProperty->getItemName()]['items']
            : [];
    }

    if ($iaView->blockExists('filters') && $iaProperty->getItemName() == $iaView->get('filtersItemName')) {
        $data = [];

        $data['locations'] = $iaLocation->search(
            [
                ['column' => iaLocation::COLUMN_STATUS, 'cond' => '=', 'value' => iaCore::STATUS_ACTIVE],
                ['column' => iaLocation::NS_LEVEL, 'cond' => '=', 'value' => 1]
            ],
            [iaLocation::COLUMN_ID, iaLocation::COLUMN_TITLE, iaLocation::COLUMN_URL],
            ['field' => iaLocation::COLUMN_TITLE, 'direction' => iaDb::ORDER_ASC]);

        $data['address'] = [
            'value' => isset($_GET['keyword']) ? iaSanitize::tags($_GET['keyword']) : '',
            'example' => ''
        ];

        if (isset($blocksData['popularCities'])) {
            $entry = $blocksData['popularCities'][mt_rand(0, count($blocksData['popularCities']) - 1)];
            if (isset($entry[iaLocation::COLUMN_TITLE])) {
                $data['address']['example'] = $entry[iaLocation::COLUMN_TITLE] . (empty($entry[iaLocation::FAKE_COLUMN_ABBREVIATION]) ? '' : ', ' . $entry[iaLocation::FAKE_COLUMN_ABBREVIATION]);
            }
        }

        $blocksData['filters'] = $data;
    }

    if ($iaView->blockExists('real_estate_enquiry_form')) {
        $iaView->assign('enquiry_form_enabled', $iaDb->one('active', iaDb::convertIds('realestate_callback_request', 'name'), 'email_templates'));
    }

    $iaView->assign('realestate', $blocksData);

    $iaView->add_css('_IA_URL_modules/' . $iaProperty->getModuleName() . '/templates/front/css/style');
}
