<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

class iaEstate extends abstractModuleAdmin implements iaRealEstateModule
{
    protected static $_table = 'estates';

    protected $_itemName = 'estate';

    protected $_statuses = [
        self::STATUS_AVAILABLE,
        iaCore::STATUS_APPROVAL,
        self::STATUS_HIDDEN,
        self::STATUS_SOLD,
        self::STATUS_RENTED
    ];

    public $dashboardStatistics = ['icon' => 'realestate', 'url' => 'realestate/properties/'];


    protected function _url(array $listingData)
    {
        return iaDb::printf(
            ':base:action/:location:id.html',
            [
                'base' => $this->getInfo('url'),
                'action' => 'view',
                'location' => isset($listingData['url']) ? $listingData['url'] : '',
                'id' => isset($listingData[self::COLUMN_ID]) ? $listingData[self::COLUMN_ID] : ''
            ]
        );
    }

    public function getSitemapEntries()
    {
        $this->iaCore->factoryModule('location', $this->getModuleName(), 'common');

        $sql = <<<SQL
SELECT t1.*, t2.`url` FROM `:table` t1 
  LEFT JOIN `:locations` t2 ON (t1.`location_id` = t2.`id`) 
WHERE t1.`status` = ':status' 
ORDER BY t1.`date_modified`
SQL;
        $sql = iaDb::printf($sql, [
            'table' => self::getTable(true),
            'locations' => iaLocation::getTable(true),
            'status' => self::STATUS_AVAILABLE
        ]);

        $result = [];

        if ($rows = $this->iaDb->getAll($sql)) {
            foreach ($rows as &$row) {
                $result[] = $this->_url($row);
            }
        }

        return $result;
    }

    public function recount($rootId = 0)
    {
        $iaLocation = $this->iaCore->factoryModule('location', $this->getModuleName(), 'common');

        $locations = $iaLocation->getChildren($rootId);
        foreach ($locations as $location) {
            $listingsNum = 0;
            if ($children = $iaLocation->getAllChildrenIds($location['id'])) {
                $condition = "(`status` = 'available' OR `status` = 'sold') AND `location_id` IN (" . implode(',', $children) . ")";
                $listingsNum = $this->iaDb->one(iaDb::STMT_COUNT_ROWS, $condition, self::getTable());

                foreach ($children as $childId) {
                    $this->recount($childId);
                }
            }

            $this->iaDb->update(['id' => $location['id'], 'num_listings' => $listingsNum], null, null, iaLocation::getTable());
        }
    }
}