<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if (iaView::REQUEST_JSON == $iaView->getRequestType()) {
    if (in_array($_GET['action'], [iaCore::ACTION_ADD, 'clear', iaCore::ACTION_DELETE, 'get'])) {
        $iaProperty = $iaCore->factoryItem('estate');

        if (!isset($_SESSION[iaEstate::SESSION_COMPARISON_KEY]) || !is_array($_SESSION[iaEstate::SESSION_COMPARISON_KEY])) {
            $_SESSION[iaEstate::SESSION_COMPARISON_KEY] = [];
        }
        $entryId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

        switch ($_GET['action']) {
            case iaCore::ACTION_ADD:
                if (count($_SESSION[iaEstate::SESSION_COMPARISON_KEY]) <= 10) {
                    $entryData = $iaProperty->getById($entryId, false, true);
                    $_SESSION[iaEstate::SESSION_COMPARISON_KEY][$entryId] = $entryData['address'];
                }
                break;
            case iaCore::ACTION_DELETE:
                if (isset($_SESSION[iaEstate::SESSION_COMPARISON_KEY][$entryId])) {
                    unset($_SESSION[iaEstate::SESSION_COMPARISON_KEY][$entryId]);
                }
                break;
            case 'clear':
                $_SESSION[iaEstate::SESSION_COMPARISON_KEY] = [];
        }

        $iaView->assign('listings', $_SESSION[iaEstate::SESSION_COMPARISON_KEY]);
    }
}

if (iaView::REQUEST_HTML == $iaView->getRequestType()) {
    $iaProperty = $iaCore->factoryItem('estate');

    $items = [];
    if (isset($_SESSION[iaEstate::SESSION_COMPARISON_KEY]) && is_array($_SESSION[iaEstate::SESSION_COMPARISON_KEY]) && $_SESSION[iaEstate::SESSION_COMPARISON_KEY]) {
        foreach ($_SESSION[iaEstate::SESSION_COMPARISON_KEY] as $entryId => $title) {
            $item = $iaProperty->getById($entryId, false, true);
            if ($item) {
                $items[] = $item;
            }
        }

        $iaField = $iaCore->factory('field');

        $iaView->assign('fields', $iaField->filter($iaProperty->getItemName(), $items));
        $iaView->assign('items', $items);
    } else {
        $iaView->setMessages(iaLanguage::get('no_items_selected_to_compare'), iaView::ALERT);
    }

    $iaView->display('compare');
}
